/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.misc.StrOpt;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidContainerList
implements Iterable<Category> {
    private final Map<class_1792, Category> emptyToFilledMap = new IdentityHashMap<class_1792, Category>();

    public FluidContainerList(List<Category> categoryList) {
        categoryList.forEach(this::addCategory);
    }

    public FluidContainerList() {
    }

    private void addCategory(Category newCategory) {
        if (!newCategory.isEmpty()) {
            if (this.emptyToFilledMap.containsKey(newCategory.emptyContainer)) {
                Category c = this.emptyToFilledMap.get(newCategory.emptyContainer);
                if (c.containerCapacity == newCategory.containerCapacity) {
                    c.filled.addAll(newCategory.filled);
                }
            } else {
                this.emptyToFilledMap.put(newCategory.emptyContainer, newCategory);
            }
        }
    }

    public Optional<class_1792> getEmpty(class_1792 filledContainer) {
        for (Map.Entry<class_1792, Category> e : this.emptyToFilledMap.entrySet()) {
            if (!e.getValue().getFilledItems().contains(filledContainer)) continue;
            return Optional.of(e.getKey());
        }
        return Optional.empty();
    }

    public Optional<class_1792> getFilled(class_1792 emptyContainer) {
        Category c = this.emptyToFilledMap.get(emptyContainer);
        if (c != null) {
            return c.getFirstFilled();
        }
        return Optional.empty();
    }

    public Optional<Category> getCategoryFromEmpty(class_1792 emptyContainer) {
        return Optional.ofNullable(this.emptyToFilledMap.get(emptyContainer));
    }

    public Optional<Category> getCategoryFromFilled(class_1792 filledContainer) {
        return this.getEmpty(filledContainer).map(this.emptyToFilledMap::get);
    }

    protected Optional<List<Category>> encodeList() {
        return this.emptyToFilledMap.isEmpty() ? Optional.empty() : Optional.of(new ArrayList<Category>(this.emptyToFilledMap.values()));
    }

    public Collection<class_1792> getPossibleFilled() {
        ArrayList<class_1792> list = new ArrayList<class_1792>();
        this.emptyToFilledMap.values().forEach(c -> list.addAll(c.filled));
        return list;
    }

    public Collection<class_1792> getPossibleEmpty() {
        return this.emptyToFilledMap.keySet();
    }

    public Collection<Category> getCategories() {
        return this.emptyToFilledMap.values();
    }

    @Override
    @NotNull
    public Iterator<Category> iterator() {
        return this.emptyToFilledMap.values().iterator();
    }

    protected void merge(FluidContainerList other) {
        other.emptyToFilledMap.values().forEach(this::addCategory);
    }

    protected void add(class_1792 empty, class_1792 filled, int amount) {
        Category c = this.emptyToFilledMap.computeIfAbsent(empty, i -> new Category((class_1792)i, amount));
        c.addItem(filled);
    }

    protected void add(class_1792 empty, class_1792 filled, int amount, class_3414 fillSound, class_3414 emptySound) {
        Category c = this.emptyToFilledMap.computeIfAbsent(empty, i -> new Category((class_1792)i, amount));
        c.addItem(filled);
        if (c.fillSound == null) {
            c.fillSound = fillSound;
        }
        if (c.emptySound == null) {
            c.emptySound = emptySound;
        }
    }

    public static class Category {
        private static final Supplier<Category> EMPTY = Suppliers.memoize(() -> new Category((class_1792)class_7923.field_41178.method_10223(class_7923.field_41178.method_10137()), 1));
        public static final Codec<Category> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("empty").forGetter(c -> Utils.getID(c.emptyContainer)), (App)SoftFluid.Capacity.INT_CODEC.fieldOf("capacity").forGetter(Category::getCapacity), (App)class_2960.field_25139.listOf().fieldOf("filled").forGetter(c -> c.filled.stream().map(Utils::getID).toList()), (App)StrOpt.of(class_7923.field_41172.method_39673(), "fill_sound").forGetter(c -> Optional.ofNullable(c.getFillSound())), (App)StrOpt.of(class_7923.field_41172.method_39673(), "empty_sound").forGetter(c -> Optional.ofNullable(c.getEmptySound()))).apply((Applicative)instance, Category::decode));
        private final class_1792 emptyContainer;
        private final int containerCapacity;
        private class_3414 fillSound;
        private class_3414 emptySound;
        private final List<class_1792> filled = new ArrayList<class_1792>();

        private Category(class_1792 emptyContainer, int capacity, @Nullable class_3414 fillSound, @Nullable class_3414 emptySound) {
            this.emptyContainer = emptyContainer;
            this.containerCapacity = capacity;
            this.fillSound = fillSound;
            this.emptySound = emptySound;
        }

        private Category(class_1792 emptyContainer, int capacity) {
            this(emptyContainer, capacity, null, null);
        }

        private static Category decode(class_2960 empty, int capacity, List<class_2960> filled) {
            return Category.decode(empty, capacity, filled, Optional.empty(), Optional.empty());
        }

        private static Category decode(class_2960 empty, int capacity, List<class_2960> filled, Optional<class_3414> fillSound, Optional<class_3414> emptySound) {
            Optional opt = class_7923.field_41178.method_17966(empty);
            if (opt.isEmpty()) {
                return EMPTY.get();
            }
            Category category = new Category((class_1792)opt.get(), capacity, fillSound.orElse(null), emptySound.orElse(null));
            filled.forEach(f -> {
                Optional opt2 = class_7923.field_41178.method_17966(f);
                opt2.ifPresent(category::addItem);
            });
            if (category.isEmpty()) {
                return EMPTY.get();
            }
            return category;
        }

        public class_1792 getEmptyContainer() {
            return this.emptyContainer;
        }

        public int getCapacity() {
            return this.containerCapacity;
        }

        @Deprecated(forRemoval=true)
        public int getAmount() {
            return this.containerCapacity;
        }

        private void addItem(class_1792 i) {
            if (!i.method_7854().method_7960() && !this.filled.contains(i)) {
                this.filled.add(i);
            }
        }

        public class_3414 getFillSound() {
            return this.fillSound == null ? class_3417.field_14779 : this.fillSound;
        }

        public class_3414 getEmptySound() {
            return this.emptySound == null ? class_3417.field_14826 : this.emptySound;
        }

        public List<class_1792> getFilledItems() {
            return this.filled;
        }

        public boolean isEmpty() {
            return this.filled.isEmpty();
        }

        public Optional<class_1792> getFirstFilled() {
            return this.filled.stream().findFirst();
        }
    }
}

